unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// rotina de clculo do CNPJ e CPF
// entrada - nmero em formato String
// sada - nmero com dgito de verificao
// a rotina testa se  CNPJ ou CPF pelo nmero de dgitos - se for 9 e CPF, se 12, CNPJ
function CalculaCnpjCpf(Numero : String) : String;
var
  i,j,k : Integer;
  Soma : Integer;
  Digito : Integer;
  CNPJ : Boolean;
begin
  case Length(Numero) of
    9 : CNPJ := False;
    12 : CNPJ := True;
    else raise Exception.Create('Nmero invlido');
  end;
  Result := Numero;
  for j := 1 to 2 do begin
    k := 2;
    Soma := 0;
    for i := Length(Result) downto 1 do begin
      Soma := Soma + (Ord(Result[i])-Ord('0'))*k;
      Inc(k);
      if (k > 9) and CNPJ then
        k := 2;
    end;
    Digito := 11 - Soma mod 11;
    if Digito >= 10 then
      Digito := 0;
    Result := Result + Chr(Digito + Ord('0'));
  end;
end; 

// rotina de clculo do mdulo 10
// entrada - nmero em formato String
// sada - nmero com dgito de verificao
function CalculaModulo10(Numero : String) : String;
var
  Digito : Integer;
  i,j,cod,N : Integer;
begin
  Numero := Trim(Numero);
  Digito := 0;
  j := 2;
  for i := Length(Numero) downto 1 do begin
    N := Ord(Numero[i])-Ord('0');
    cod := (N mod 10)*j;
    Digito := Digito + (cod mod 10)+(cod div 10);
    if j = 2 then
      j := 1
    else
      j := 2;
  end;
  Digito := Digito mod 10;
  if Digito <> 0 then
    Result := Numero+IntToStr(10-Digito)
  else
    Result := Numero + '0';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShowMessage(CalculaCnpjCpf(Edit1.Text));
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ShowMessage(CalculaModulo10(Edit1.Text));
end;

end.
